/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.core;

import com.mojang.datafixers.util.Pair;
import com.tterrag.registrate.util.entry.ItemEntry;
import dev.xkmc.l2artifacts.content.client.tab.DarkTextColorRanks;
import dev.xkmc.l2artifacts.content.config.ArtifactSetConfig;
import dev.xkmc.l2artifacts.content.core.BaseArtifact;
import dev.xkmc.l2artifacts.content.effects.core.PlayerOnlySetEffect;
import dev.xkmc.l2artifacts.content.search.token.IArtifactFeature;
import dev.xkmc.l2artifacts.events.ArtifactEffectEvents;
import dev.xkmc.l2artifacts.init.L2Artifacts;
import dev.xkmc.l2artifacts.init.data.ArtifactConfig;
import dev.xkmc.l2artifacts.init.data.LangData;
import dev.xkmc.l2artifacts.init.registrate.ArtifactTypeRegistry;
import dev.xkmc.l2library.base.NamedEntry;
import dev.xkmc.l2library.util.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class ArtifactSet
extends NamedEntry<ArtifactSet>
implements IArtifactFeature.ItemIcon {
    private static int[] remapRanks(int[] rank) {
        for (int i = rank.length - 2; i >= 0; --i) {
            int n = i;
            rank[n] = rank[n] + rank[i + 1];
        }
        int[] ranks = new int[6];
        for (int i = 0; i <= 5; ++i) {
            for (int j = 0; j < rank.length; ++j) {
                if (rank[j] < i) continue;
                ranks[i] = Math.max(ranks[i], j);
            }
        }
        return ranks;
    }

    private MutableComponent getCountDesc(int count) {
        int max = L2Artifacts.REGISTRATE.SET_MAP.get((Object)this.getRegistryName()).items.length;
        return LangData.getTranslate("set." + count, max);
    }

    public ArtifactSet() {
        super(ArtifactTypeRegistry.SET);
    }

    public Optional<SetContext> getCountAndIndex(@Nullable SlotContext context) {
        Object e = context == null ? Proxy.getPlayer() : context.entity();
        Optional opt = CuriosApi.getCuriosInventory((LivingEntity)e).resolve();
        if (opt.isPresent()) {
            List list = ((ICuriosItemHandler)opt.get()).findCurios(stack -> {
                Item patt2517$temp = stack.m_41720_();
                if (!(patt2517$temp instanceof BaseArtifact)) return false;
                BaseArtifact artifact = (BaseArtifact)patt2517$temp;
                if (artifact.set.get() != this) return false;
                return true;
            });
            int[] rank = new int[(Integer)ArtifactConfig.COMMON.maxRank.get() + 1];
            int index = -1;
            int count = 0;
            for (SlotResult result : list) {
                Item item = result.stack().m_41720_();
                if (!(item instanceof BaseArtifact)) continue;
                BaseArtifact artifact = (BaseArtifact)item;
                if (artifact.set.get() != this) continue;
                int n = artifact.rank;
                rank[n] = rank[n] + 1;
                if (context != null && context.identifier().equals(result.slotContext().identifier()) && context.index() == result.slotContext().index()) {
                    index = count;
                }
                ++count;
            }
            return Optional.of(new SetContext(list.size(), ArtifactSet.remapRanks(rank), index));
        }
        return Optional.empty();
    }

    public Optional<SetContext> getSetCount(LivingEntity e) {
        Optional opt = CuriosApi.getCuriosInventory((LivingEntity)e).resolve();
        if (opt.isPresent()) {
            List list = ((ICuriosItemHandler)opt.get()).findCurios(stack -> {
                Item patt3368$temp = stack.m_41720_();
                if (!(patt3368$temp instanceof BaseArtifact)) return false;
                BaseArtifact artifact = (BaseArtifact)patt3368$temp;
                if (artifact.set.get() != this) return false;
                return true;
            });
            int[] rank = new int[(Integer)ArtifactConfig.COMMON.maxRank.get() + 1];
            int count = 0;
            for (SlotResult result : list) {
                Item item = result.stack().m_41720_();
                if (!(item instanceof BaseArtifact)) continue;
                BaseArtifact artifact = (BaseArtifact)item;
                if (artifact.set.get() != this) continue;
                int n = artifact.rank;
                rank[n] = rank[n] + 1;
                ++count;
            }
            return Optional.of(new SetContext(list.size(), ArtifactSet.remapRanks(rank), -1));
        }
        return Optional.empty();
    }

    public void update(SlotContext context) {
        LivingEntity e = context.entity();
        Optional<SetContext> result = this.getCountAndIndex(context);
        if (result.isPresent()) {
            ArtifactSetConfig config = ArtifactSetConfig.getInstance();
            ArrayList<ArtifactSetConfig.Entry> list = config.map.get(this);
            for (ArtifactSetConfig.Entry ent : list) {
                ent.effect.update(e, ent, result.get().ranks()[ent.count], result.get().count() >= ent.count);
            }
        }
    }

    public void tick(SlotContext context) {
        LivingEntity e = context.entity();
        Optional<SetContext> result = this.getCountAndIndex(context);
        if (result.isPresent() && result.get().current_index() == 0) {
            ArtifactSetConfig config = ArtifactSetConfig.getInstance();
            ArrayList<ArtifactSetConfig.Entry> list = config.map.get(this);
            for (ArtifactSetConfig.Entry ent : list) {
                ent.effect.tick(e, ent, result.get().ranks()[ent.count], result.get().count() >= ent.count);
            }
        }
    }

    public <T> void propagateEvent(SlotContext context, T event, ArtifactEffectEvents.EventConsumer<T> cons) {
        LivingEntity e = context.entity();
        Optional<SetContext> result = this.getCountAndIndex(context);
        if (result.isPresent() && result.get().current_index() == 0) {
            ArtifactSetConfig config = ArtifactSetConfig.getInstance();
            ArrayList<ArtifactSetConfig.Entry> list = config.map.get(this);
            for (ArtifactSetConfig.Entry ent : list) {
                if (result.get().count() < ent.count) continue;
                cons.apply(ent.effect, e, ent, result.get().ranks()[ent.count], event);
            }
        }
    }

    public <T> boolean propagateEvent(SlotContext context, T event, ArtifactEffectEvents.EventPredicate<T> cons) {
        LivingEntity e = context.entity();
        boolean ans = false;
        Optional<SetContext> result = this.getCountAndIndex(context);
        if (result.isPresent() && result.get().current_index() == 0) {
            ArtifactSetConfig config = ArtifactSetConfig.getInstance();
            ArrayList<ArtifactSetConfig.Entry> list = config.map.get(this);
            for (ArtifactSetConfig.Entry ent : list) {
                if (result.get().count() < ent.count) continue;
                ans |= cons.apply(ent.effect, e, ent, result.get().ranks()[ent.count], event);
            }
        }
        return ans;
    }

    public List<MutableComponent> getAllDescs(ItemStack stack, boolean show) {
        Optional<SetContext> opt;
        ArrayList<MutableComponent> ans = new ArrayList<MutableComponent>();
        BaseArtifact artifact = (BaseArtifact)stack.m_41720_();
        ArtifactSetConfig config = ArtifactSetConfig.getInstance();
        ArrayList<ArtifactSetConfig.Entry> list = config.map.get(this);
        if (Proxy.getPlayer() != null && (opt = this.getSetCount((LivingEntity)Proxy.getPlayer())).isPresent()) {
            SetContext ctx = opt.get();
            ans.add(LangData.SET.get(Component.m_237115_((String)this.getDescriptionId()).m_130940_(ChatFormatting.YELLOW)));
            if (show) {
                for (ArtifactSetConfig.Entry ent : list) {
                    ChatFormatting color_count = ctx.count() < ent.count ? ChatFormatting.GRAY : ChatFormatting.GREEN;
                    ChatFormatting color_title = ctx.count() < ent.count || ctx.ranks()[ent.count] < artifact.rank ? ChatFormatting.GRAY : ChatFormatting.GREEN;
                    ChatFormatting color_desc = ctx.count() < ent.count || ctx.ranks()[ent.count] < artifact.rank ? ChatFormatting.DARK_GRAY : ChatFormatting.DARK_GREEN;
                    ans.add(this.getCountDesc(ent.count).m_130940_(color_count).m_7220_((Component)ent.effect.getDesc().m_130940_(color_title)));
                    List<MutableComponent> desc = ent.effect.getDetailedDescription(artifact.rank);
                    for (MutableComponent comp : desc) {
                        ans.add(comp.m_130940_(color_desc));
                    }
                }
            }
        }
        if (!show) {
            boolean playerOnly = false;
            for (ArtifactSetConfig.Entry e : list) {
                playerOnly |= e.effect instanceof PlayerOnlySetEffect;
            }
            if (playerOnly) {
                ans.add(LangData.PLAYER_ONLY.get(new Object[0]).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
        return ans;
    }

    public List<Pair<List<Component>, List<Component>>> addComponents(SetContext ctx) {
        ArrayList<Pair<List<Component>, List<Component>>> ans = new ArrayList<Pair<List<Component>, List<Component>>>();
        ans.add(Pair.of(List.of(LangData.ALL_SET_EFFECTS.get(this.getDesc(), ctx.count())), List.of()));
        ArtifactSetConfig config = ArtifactSetConfig.getInstance();
        ArrayList<ArtifactSetConfig.Entry> list = config.map.get(this);
        for (ArtifactSetConfig.Entry ent : list) {
            if (ctx.count() < ent.count) continue;
            int rank = ctx.ranks[ent.count];
            List<MutableComponent> a = List.of(this.getCountDesc(ent.count), ent.effect.getDesc().m_130940_(DarkTextColorRanks.getDark(rank)));
            ArrayList<Object> b = new ArrayList<Object>();
            b.add(this.getCountDesc(ent.count).m_7220_((Component)ent.effect.getDesc().m_130940_(DarkTextColorRanks.getLight(rank))));
            b.addAll(ent.effect.getDetailedDescription(rank).stream().map(comp -> comp.m_130940_(DarkTextColorRanks.getDark(rank))).toList());
            ans.add((Pair<List<Component>, List<Component>>)Pair.of(a, b));
        }
        return ans;
    }

    @Override
    public Item getItemIcon() {
        ItemEntry<BaseArtifact>[][] arr = L2Artifacts.REGISTRATE.SET_MAP.get((Object)this.getRegistryName()).items;
        return (Item)arr[0][arr[0].length - 1].get();
    }

    @Override
    @Nullable
    public NonNullList<ItemStack> getTooltipItems() {
        ItemEntry<BaseArtifact>[][] arr = L2Artifacts.REGISTRATE.SET_MAP.get((Object)this.getRegistryName()).items;
        NonNullList ans = NonNullList.m_122779_();
        for (ItemEntry<BaseArtifact>[] ar : arr) {
            ans.add((Object)ar[ar.length - 1].asStack());
        }
        return ans;
    }

    public record SetContext(int count, int[] ranks, int current_index) {
    }
}

